<!doctype html>
<html class="no-js" lang="en">
    <?php
    $settings = $this->frontend_model->getSettings();
    $webSettings = $this->frontend_model->getWebSettings();
    $title = explode(' ', $settings->title);
    ?>
    <head>
        <base href="<?php echo base_url(); ?>">
        <meta charset="utf-8">
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Hospital Management </title>
        <meta name="description" content="">
        <meta name="keywords" content="">
        <link rel="shortcut icon" href="uploads/favicon.png">
        <link rel="stylesheet" href="front/css/font-awesome/css/font-awesome.min.css">
        <link rel="stylesheet" href="front/css/bootstrap/bootstrap.min.css">
        <link rel="stylesheet" href="front/css/style.css">
        <link rel="stylesheet" href="front/css/responsive.css">
        <link href="common/assets/DataTables/datatables.min.css" rel="stylesheet" />

    </head>

    <body data-spy="scroll" data-target=".navbar" data-offset="20">

    <div class="container bg-light">
        <header>
            <nav class="navbar navbar-expand-md fixed-top">
                <div class="container bg-light">
                    <a class="navbar-brand" href="frontend#header">
                        <?php
                        if (!empty($settings->logo)) {
                            if (file_exists($settings->logo)) {
                                echo '<img width="100" src=' . $settings->logo . '>';
                            } else {
                                echo $title[0] . '<span> ' . $title[1] . '</span>';
                            }
                        } else {
                            echo $title[0] . '<span> ' . $title[1] . '</span>';
                        }
                        ?>
                    </a>
                    <button class="navbar-toggler" data-toggle="collapse" data-target="#navbar"> 
                        <span><i class="fa fa-bars"></i></span>
                    </button>

                    <div class="collapse navbar-collapse flex-column bg-primary " id="navbar">
                    <ul class="navbar-nav  w-100 px-3 bg-primary">
                        <li class="nav-item"> <span style="display: flex; align-items:center"><i class="fa fa-envelope"></i> <a class="nav-link" href="mailto:<?php echo $settings->email; ?>"><?php echo $settings->email; ?></a></span></li>
                        <li class="nav-item"> <span style="display: flex; align-items:center; width: max-content;"><i class="fa fa-phone"></i> <a class="nav-link" href="tel:<?php echo $settings->phone; ?>"><?php echo $settings->phone; ?></a></span></li>
                        <span id="social">
                                                <?php if (!empty($webSettings->facebook_id)) { ?>
                                                    <li><a class="nav-link" target="_blank" href="<?php echo $webSettings->facebook_id; ?>"><i class="fa fa-facebook"></i></a></li> <?php } ?>
                                                <?php if (!empty($webSettings->twitter_id)) { ?>
                                                    <li><a class="nav-link" target="_blank" href="<?php echo $webSettings->twitter_id; ?>"><i class="fa fa-twitter"></i></a></li> <?php } ?>
                                                <?php if (!empty($webSettings->linkedin_id)) { ?>
                                                    <li><a class="nav-link" target="_blank" href="<?php echo $webSettings->linkedin_id; ?>"><i class="fa fa-linkedin"></i></a></li> <?php } ?>
                                                <?php if (!empty($webSettings->youtube_id)) { ?>
                                                    <li><a class="nav-link" target="_blank" href="<?php echo $webSettings->youtube_id; ?>"><i class="fa fa-youtube"></i></a></li> <?php } ?>
                                                    </span></ul>

                     <ul class="navbar-nav  w-100 bg-secondary px-3 bg-info" style="min-height: 70px;">
                        <li class="nav-item"><a class="nav-link" href="frontend">HOME</a></li>
                        <li class="nav-item"><a class="nav-link" href="frontend#hospital-management"><?php echo strtoupper(lang('specialities')); ?></a></li>
                        <li class="nav-item"><a class="nav-link" href="frontend#doctors">DOCTORS</a></li>
                        <li class="nav-item"><a class="nav-link" href="frontend#cost"><?php echo strtoupper(lang('service')); ?> <?php echo strtoupper(lang('charge')); ?></a></li>
                        <li class="nav-item"><a class="nav-link" href="frontend#footer">CONTACT</a></li>
                     </ul>
                     
                </div>
            </div>
            </nav>
        </header>


        <section id="header" class="py-4">
            <!-- revolution slider start -->
            <div class="fullwidthbanner-container main-slider">
                <div class="fullwidthabnner">
                    <ul id="revolutionul">
                        <!-- 1st slide -->

                    
                            <?php
                            foreach ($slides as $slide) {
                                if ($slide->status == 'Active') {
                                    ?>

                                    <li data-transition="fade" data-slotamount="8" data-masterspeed="700" data-delay="5000" data-thumb="">
                                        <div class="caption lfl slide_item_left"
                                             data-x="10"
                                             data-y="70"
                                             data-speed="400"
                                             data-start="0"
                                             data-easing="easeOutBack">
                                            <img class="slider" src="<?php echo $slide->img_url; ?>" alt="Image 1">
                                        </div>
                                        
                                    </li>

                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
                <!-- revolution slider end -->

            </section>

            <section id="hospital-management">
                <div class="content-lg">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h2><?php echo $settings->title; ?></h2>
                                <p><?php echo $settings->block_1_text_under_title; ?></p>
                            </div>
                            <?php
                            $message = $this->session->flashdata('feedback');
                            if (!empty($message)) {
                                ?>
                                <div class="flashmessage col-md-12" style="text-align: center;
                                     color: green;
                                     font-size: 23px;
                                     font-weight: 500;"> <?php echo $message; ?></div>

                            <?php } ?>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <div class="card-content">
                                            <i class="fa fa-phone phone"></i>
                                            <h6><a href="tel:<?php echo $webSettings->emergency; ?>"><?php echo lang('call'); ?> <?php echo lang('emergency'); ?></a></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card mb-3" data-toggle="" data-target="">
                                    <div class="card-body card-2nd">
                                        <div class="card-content">
                                            <i class="fa fa-calendar"></i>
                                            <h6><a href="tel:<?php echo $webSettings->support; ?>"><?php echo lang('book_an_appointment'); ?></a></h6>
                                        </div>

                                    </div>
                                </div>                                
                            </div>
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <div class="card-content">
                                            <i class="fa fa-heart heart"></i>
                                            <h6>24/7 SUPPORT</h6>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>


            <section id="service">

                <div class="content-lg bg-light">
                    <div class="container">
                        <div class="row py-4">
                            <div class="col-md-12 text-center">
                                <h2>Our <?php echo lang('specialities'); ?></h2>
                                <h6 class="lead"><?php echo $settings->service_block__text_under_title; ?></h6>
                            </div>
                        </div>

                        <div class="row text-center py-1">
                            <?php foreach ($services as $service) { ?>
                                <div class="col-md-4 justify-content-between">
                                    <div class="service-content-left">
                                        <img width="150px" style="border-radius: 100px" src=" <?php echo $service->img_url; ?>" alt=""> 
                                            <h4><?php echo $service->title; ?></h4>
                                            <p><?php echo $service->description; ?></p>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>

                        </div>
                    </div>

                </section>


                <section id="doctors" class="py-4">
                    <div class="content-lg">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center pb-4">
                                    <h2>Our Doctors</h2>
                                    <p><?php echo $settings->doctor_block__text_under_title; ?></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="container" >
                                    <div class="row">
                                        <?php
                                        $count = count($featureds);
                                        $i = 1;
                                        foreach ($featureds as $featured) {
                                            $doctor = $this->db->get_where('doctor', array('id' => $featured->name))->row();
                                            ?>
                                        <div class="col-lg-3 mb-3" >
                                            <div class="person">
                                                <div class="text-center py-2">
                                                <img style="width:165px" src="<?php echo $doctor->img_url; ?>" alt="">
                                                <?php if  (empty($doctor->img_url))  { ?>                                                                                                
                                                    <img style="width:165px" src="uploads/doctor.png" alt="">
                                                <?php  } ?>  
                                                </div>
                                                <div class="person-info text-center">
                                                    <strong>
                                                        <?php echo $doctor->name; ?></a>
                                                    </strong>
                                                    <p class=""> <?php echo $doctor->profile; ?> </p>
                                                    <p><?php echo $doctor->designation; ?></p>
                                                    <p class="text-muted"><?php echo $doctor->department; ?></p>
                                                </div>
                                                <div class="text-center">
                                                <a class="text-primary editbutton" type="button" data-toggle = "modal" data-id="<?php echo $doctor->id;?>">Visiting Hours</a>
                                                </div>
                                            </div>
                                        </div>
                                            <?php
                                            $i = $i + 1;
                                        }
                                        ?>
                                    </div>
                               
                                </div>
                            </div> 
                        </div>
                    </div>
                </section>

                <section id="cost" class="py-4">
                    <div class="content-lg">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center pb-2">
                                    <h2><?php echo lang('service'); ?> <?php echo lang('charge'); ?></h2>
                                </div>
                            </div>
                            <div class="col-md-12">                            
                            <table class="table table-striped table-hover table-bordered" id="editable-sample">
                                <thead>
                                <tr>
                                 <th><?php echo lang('service'); ?> <?php echo lang('name'); ?></th>
                                 <th><?php echo lang('category'); ?></th>
                                 <th><?php echo lang('charge'); ?></th>
                                </tr>
                                 </thead>
                        <tbody>

                        <?php foreach ($categories as $category) { ?>
                            <tr class="">
                                <td><?php echo $category->category; ?></td>   
                                <td><?php echo $this->finance_model->getPaymentServiceCategoryById($category->service_category)->category; ?></td>   
                                <td><?php echo $settings->currency; ?> <?php echo $category->c_price; ?></td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                            </div>
                        </div>
                    </div>
                </section>

                <div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
                    <div class="modal-dialog modal-lg"> 
                        <div class="modal-content">
                         <div class="modal-header">
                             <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                         </div>
                        <div class="modal-body row">
                    <table id="results" class="table table-striped table-hover table-bordered">
                    <thead>
                     <tr>
                        <td class="font-weight-bold"><?php echo lang('weekday'); ?></td>
                        <td class="font-weight-bold">Visiting Hour</td>
                     </tr>
                    </thead>
                     <tboby>
                     </tbody>
                    </table>

                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
                </div>
            </div>


                <footer id="footer" class="pt-4">
                        <div class="container">
                            <div class="row">
  
                                <div class="col-md-4">
                                    <div class="col-md-12">
                                        <h4 class="">About Us</h4>
                                                <div class="">
                                                    <p><?php echo $settings->title; ?>   <?php echo $webSettings->about_us; ?>                                                     
                                                    </p>
                                                </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-md-12">
                                        <h4>Quick Links</h4>
                                        <div class="col-md-12">
                                            <ul style="margin-left: -35px;">                                           
                                            <li class="nav-item"><a class="nav-link" href="frontend#hospital-management"><?php echo lang('specialities'); ?></a></li>
                                            <li class="nav-item"><a class="nav-link" href="frontend#doctors">Doctors</a></li>
                                            <li class="nav-item"><a class="nav-link" href="frontend#cost"><?php echo lang('service'); ?> <?php echo lang('charge'); ?></a></li>
                                         </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 mb-4 text-white">
                                    <div class="col-md-12">
                                        <h4><?php echo lang('contact_us'); ?></h4>
                                        <p class="text-white"><i class="fa fa-hospital-o"></i> <?php echo $settings->title; ?></p>
                                        <p class="text-white"><i class="fa fa-map-marker"></i> <?php echo $settings->address; ?></p>
                                        <p class="text-white"><i class="fa fa-phone"></i> <?php echo $settings->phone; ?></p>
                                        <p class="text-white"><i class="fa fa-envelope"></i> <?php echo $settings->email; ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center" style="padding-top: 10px; padding-bottom: 10px; background:#81afd2!important">
                                &copy;<?php echo date('Y'); ?>. <?php echo lang('developer_front1'); ?> <a target="_blank" style="color:black; font-weight:bolder" href="https://shanmedicalbd.com"><?php echo lang('developer_front2'); ?></a>. <?php echo lang('developer_front3'); ?>
                            </div>
                        </div>

                </footer>

            <!-- Messenger Chat plugin Code -->
            <div id="fb-root"></div>

<!-- Your Chat plugin code -->
<div id="fb-customer-chat" class="fb-customerchat">
</div>

<script>
  var chatbox = document.getElementById('fb-customer-chat');
  chatbox.setAttribute("page_id", "<?php echo $settings->facebook_id;?>");
  chatbox.setAttribute("attribution", "biz_inbox");

  window.fbAsyncInit = function() {
    FB.init({
      xfbml            : true,
      version          : 'v12.0'
    });
  };

  (function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
    fjs.parentNode.insertBefore(js, fjs);
  }(document, 'script', 'facebook-jssdk'));
</script>
                </div>

                
                <style>

           
                    .slide_item_left {  
                    left: 0px !important;
                    background-size: contain !important;
                    position: absolute;
                    }

                    h1 {
                    font-size: 2.5rem !important;
                    }

                    .navbar {
                    padding:0rem;
                    margin-bottom:2rem;
                    }

                    .dropdown .dropdown-menu {
                    border-radius:0;
                    }

                    .container {
                    padding-left:1px;
                    padding-right:1px;
                    }

                    .bg-info {
                    background-color: #1f5184!important;
                    }

                    .bg-primary {
                    background-color: #11436a!important;
                    }

                    .navbar-nav {
                    align-items: center;
                    }

                    .slider {
                        width: 1140px !important;
                        height: 500px !important;
                    }

                    #service {
                    border-top: 1px solid gainsboro;
                    }

                    #doctors {
                    border-top: 1px solid gainsboro;
                    }

                    #cost {
                    border-top: 1px solid gainsboro;
                    }

                    .fullwidthbanner-container {
                     overflow: visible;
                    }

                    li 
                    {
                        color:white;
                    }

                    p {
                        margin-bottom: 0.1rem;
                    }

                    .dataTables_wrapper {
                        width:100%
                    }

                    table.dataTable thead th, table.dataTable thead td {
                        padding: 10px 11px;
                    }

                    .navbar-toggler .fa {
                        color: black;
                    }
                    .modal-body {
                        background: white;

                    }

                    #hospital-management .card {
                     background: #d2f996;
                    }

                    .row {
                        margin-right: -5px;
                        margin-left: -5px;
                    }

                    #social {
                    margin-left: 520px;
                    display: flex;
                    }

                    #header {
                    margin-top: 86px;
                    height: 550px;
                    }

                    .nav-link {
                    padding: 0.1rem 0.3rem;
                    }

                    @media (min-width: 768px) {  
                    .dropdown:hover .dropdown-menu {
                    display: block;
                    margin-top: 0;
                    border-radius:0;
                    }

                    .bg-primary {
                    height: 112px;
                    }

                    }

                    @media (max-width: 767px) {  
                     #header {
                        display: none;
                    }
                    .fixed-top {
                        position: static;
                    }
                    #social {
                    margin-left: 0px;
                    }
                    }
                </style> 

                 <script src="common/js/jquery.js"></script>
                <script src="front/js/bootstrap/bootstrap.min.js"></script>
                <script type="text/javascript" src="common/assets/DataTables/datatables.min.js"></script>
                
                <script>

                    $(document).ready(function () {
                        $('.caption img').removeAttr('style');
                        var windowH = $(window).width();
                        $('.caption img').css('width', (windowH) + 'px');
                        $('.caption img').css('height', '500px');
                    });

                </script>

                        <script>
                                            $(document).ready(function () {
                                                var table = $('#editable-sample').DataTable({
                                                    responsive: true,               

                                                    dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                                                            "<'row'<'col-sm-12'tr>>" +
                                                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                                                    buttons: [  
                                                    ],

                                                    aLengthMenu: [
                                                    [25, 50, 100, -1],
                                                    [25, 50, 100, "All"]
                                                    ],
                                                    iDisplayLength: 25,                                                   
                                                    "language": {
                                                        "lengthMenu": "_MENU_",
                                                        search: "_INPUT_",
                                                    },

                                                });

                                                table.buttons().container()
                                                        .appendTo('.custom_buttons');
                                            });
                            </script>


<script type="text/javascript">

$("#doctors").on("click", ".editbutton", function () {

    var iid = $(this).attr('data-id');

    $.ajax({
        url: 'frontend/timeScheduleByJason?doctor=' + iid,
        method: 'GET',
        data: '',
        dataType: 'json',
    }).success(function (selected) {
        //console.log(selected.schedules.length);
 
        $('#results tbody').empty();
    for (var i = 0; i < selected.schedules.length; i++) {
        $("#results").append("<tr><td>"+selected.schedules[i].weekday+"</td><td>"+selected.schedules[i].s_time+" - "+selected.schedules[i].e_time+"</td></tr>");
    }

        $('#modal').modal('show');

    });
});

</script>


            </body></html>