<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Donor extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('donor_model');

        if (!$this->ion_auth->in_group(array('admin', 'Receptionist', 'Laboratorist'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data['donors'] = $this->donor_model->getDonor();
        $data['groups'] = $this->donor_model->getBloodBank();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('donor', $data);
        $this->load->view('home/footer'); // just the header file
    }


    public function addDonor() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $group = $this->input->post('group');
        $age = $this->input->post('age');
        $sex = $this->input->post('sex');
        $ldd = $this->input->post('ldd');
        $phone = $this->input->post('phone');
        $email = $this->input->post('email');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('group', 'group', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('age', 'age', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('sex', 'sex', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('ldd', 'Last Donation Date', 'trim|min_length[2]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('phone', 'phone', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Name Field
        $this->form_validation->set_rules('email', 'email', 'trim|min_length[2]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
                $data = array();
                $data['groups'] = $this->donor_model->getBloodBank();
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('donor', $data);
                $this->load->view('home/footer'); // just the footer file
        } else {
            $data = array();
            $data = array('name' => $name,
                'group' => $group,
                'age' => $age,
                'sex' => $sex,
                'ldd' => $ldd,
                'phone' => $phone,
                'email' => $email,
                'add_date' => time(),
                'added_by' =>$this->ion_auth->get_user_id(),
            );
            if (empty($id)) {
                $this->donor_model->insertDonor($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                unset($data["add_date"]);
                unset($data["added_by"]);
                $data["updated_by"] = $this->ion_auth->get_user_id();
                $data["updated_date"] = time();
                $this->donor_model->updateDonor($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('donor');
        }
    }

  
    function editDonorByJason() {
        $id = $this->input->get('id');
        $data['donor'] = $this->donor_model->getDonorById($id);
        $data['updated_date'] = "";
        if (!empty($data['donor']->updated_date))
        $data['updated_date'] = date('d-m-Y h:i A', $data['donor']->updated_date);
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $this->donor_model->deleteDonor($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('donor');
    }

    public function bloodBank() {
        $data['groups'] = $this->donor_model->getBloodBank();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('blood_bank', $data);
        $this->load->view('home/footer'); // just the header file
    }

     public function updateBloodBank() {
        $id = $this->input->post('id');
        $group = $this->input->post('group');
        $status = $this->input->post('status');
        $location = $this->input->post('location');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('status', 'Status', 'trim|required|min_length[5]|max_length[100]');
        $this->form_validation->set_rules('location', 'Location', 'trim|min_length[5]|max_length[100]');

        if ($this->form_validation->run() == FALSE) {
             $this->session->set_flashdata('feedback', lang('validation_error'));
            redirect('donor/bloodBank');
        } else {
            $data = array();
            $data = array(
                'status' => $status,
                'location' => $location,
                'updated_date' => time(),
                'updated_by' =>$this->ion_auth->get_user_id(),

            );

            $this->donor_model->updateBloodBank($id, $data);
            $this->session->set_flashdata('feedback', lang('updated'));
            redirect('donor/bloodBank');
        }
    }

    function getBloodBankByJason() {
        $id = $this->input->get('id');
        $data['bloodbank'] = $this->donor_model->getBloodBankById($id);
        $data['updated_date'] = date('d-m-Y h:i A', $data['bloodbank']->updated_date);
        $data['updated_by'] = $this->db->get_where('users', array('id' => $data['bloodbank']->updated_by))->row()->username;
        echo json_encode($data);
    }

}

/* End of file accountant.php */
/* Location: ./application/modules/accountant/controllers/accountant.php */
