<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bed_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertBed($data) {
        $this->db->insert('bed', $data);
    }

    function getBed() {
        $query = $this->db->get('bed');
        return $query->result();
    }

    function getBedWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get('bed');
        return $query->result();
    }

    function getBedBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('bed_name', $search); //changed by shariat
        $this->db->or_like('description', $search);
        $query = $this->db->get('bed');
        return $query->result();
    }

    function getBedByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('bed');
        return $query->result();
    }

    function getBedByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('bed_name', $search); //changed by shariat
        $this->db->or_like('description', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('bed');
        return $query->result();
    }

    function getBedById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('bed');
        return $query->row();
    }

    //added by shariat
    function getAvailableBed() {
        $this->db->where('status', lang(status_running));
        $query = $this->db->get('bed');
        return $query->result();
    }
    //added by shariat
    function getFreeBed() {
        $this->db->order_by('category', 'asc');
        $this->db->where('status', lang(status_inactive));
        $query = $this->db->get('bed');
        return $query->result();
    }

    function updateBed($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('bed', $data);
    }

    function updateBedByBedId($bed_id, $data) {
        $this->db->where('id', $bed_id); //changed by shariat from bed_id to id
        $this->db->update('bed', $data);
    }

    //added by shariat
    function updateBedByPaymentCategoryId($payment_category_id, $data) {
        $this->db->where('payment_category_id', $payment_category_id);
        $this->db->update('bed', $data);
    }

    function insertBedCategory($data) {
        $this->db->insert('bed_category', $data);
    }

    function getBedCategory() {
        $query = $this->db->get('bed_category');
        return $query->result();
    }

    function getBedAllotmentsByPatientId($id) {
        $this->db->select('alloted_bed.id,alloted_bed.bed_id,alloted_bed.patient,alloted_bed.patient_name,alloted_bed.patient_phone,alloted_bed.a_time,alloted_bed.d_time,bed.bed_name');
        $this->db->from('alloted_bed');
        $this->db->where('alloted_bed.patient', $id);
        $this->db->join('bed', 'alloted_bed.bed_id=bed.id','LEFT'); 
        $query = $this->db->get();
        return $query->result();
    }

    function getBedCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('bed_category');
        return $query->row();
    }

    function updateBedCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('bed_category', $data);
    }

    function deleteBed($id) {
        $this->db->where('id', $id);
        $this->db->delete('bed');
    }

    //added by shariat
    function deleteBedByPaymentCategoryId($payment_category_id) {
        $this->db->where('payment_category_id', $payment_category_id);
        $this->db->delete('bed');
    }

    function deleteBedCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('bed_category');
    }

    function insertAllotment($data) {
        $this->db->insert('alloted_bed', $data);
    }

    function getAllotment() {
        $this->db->where('status', lang(status_running)); //added by shariat
        $query = $this->db->get('alloted_bed');
        return $query->result();
    }

    function getAllotmentWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('status', lang(status_running));
        $query = $this->db->get('alloted_bed');
        return $query->result();
    }

    function getBedAllotmentRunning() {
        $this->db->select('alloted_bed.id,alloted_bed.bed_id,alloted_bed.patient,alloted_bed.patient_name,alloted_bed.patient_phone,alloted_bed.a_time,bed.bed_name');
        $this->db->from('alloted_bed');
        $this->db->where('alloted_bed.status', lang(status_running)); //added by shariat (running & other condition)  
        $this->db->join('bed', 'alloted_bed.bed_id=bed.id','LEFT'); 
        $query = $this->db->get();
        return $query->result();
    }

    function getBedAllotmentBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('alloted_bed.id,alloted_bed.bed_id,alloted_bed.patient,alloted_bed.patient_name,alloted_bed.patient_phone,alloted_bed.a_time,alloted_bed.d_time,alloted_bed.status,bed.bed_name');
        $this->db->where('alloted_bed.status', lang(status_running)); //added by shariat (running & other condition)
        $this->db->group_start();
        $this->db->like('bed.bed_name', $search);
        $this->db->or_like('alloted_bed.patient', $search,'after'); 
        $this->db->or_like('alloted_bed.patient_name', $search);  
        $this->db->or_like('alloted_bed.patient_phone', $search);   
        $this->db->group_end(); 
        $this->db->from('alloted_bed'); 
        $this->db->join('bed', 'alloted_bed.bed_id=bed.id','LEFT'); 
        $query = $this->db->get();
        return $query->result();
        }
    }

    function getBedAllotmentByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('alloted_bed.id,alloted_bed.bed_id,alloted_bed.patient,alloted_bed.patient_name,alloted_bed.patient_phone,alloted_bed.a_time,alloted_bed.d_time,alloted_bed.status,bed.bed_name');
        $this->db->from('alloted_bed'); 
        $this->db->join('bed', 'alloted_bed.bed_id=bed.id','LEFT'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
    }

    function getBedAllotmentByLimitBySearch($limit, $start, $search, $order, $dir) {

        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('alloted_bed.id,alloted_bed.bed_id,alloted_bed.patient,alloted_bed.patient_name,alloted_bed.patient_phone,alloted_bed.a_time,alloted_bed.d_time,alloted_bed.status,bed.bed_name');
        $this->db->like('bed.bed_name', $search);
        $this->db->or_like('patient', $search,'after'); 
        $this->db->or_like('patient_name', $search);  
        $this->db->or_like('patient_phone', $search);    
        $this->db->from('alloted_bed'); 
        $this->db->join('bed', 'alloted_bed.bed_id=bed.id','LEFT'); 
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        return $query->result();
        }
    }

    function getAllotmentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('alloted_bed');
        return $query->row();
    }

    function updateAllotment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('alloted_bed', $data);
    }

    function deleteBedAllotment($id) {
        $this->db->where('id', $id);
        $this->db->delete('alloted_bed');
    }

    //added by shariat
    function deleteBedAllotmentNew($id) {
        $d_time = time(); //current time by shariat
        $this->db->set('status', lang(status_inactive));
        $this->db->set('d_time', $d_time);
        $this->db->where('id', $id);
        $this->db->update('alloted_bed');
    }

}
