<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Patient_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPatient($data) {
        $this->db->insert('patient', $data);
    }

    function getPatient() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('patient');
        return $query->result();
    }

    function getPatientSMS() {
        $this->db->distinct();
        $query = $this->db->get('patient');
        return $query->result();
    }

    function getPatientWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,name,phone,address,age');
        $query = $this->db->get('patient');
        return $query->result();
    }

    function getPatientBySearch($search, $order, $dir) {
        if (strlen($search)>1)
        {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,name,phone,address,age');
        $this->db->like('id', $search,'after');
        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $query = $this->db->get('patient');
        return $query->result();
        }
    }

    function getPatientByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('id,name,phone,address,age');
        $this->db->limit($limit, $start);
        $query = $this->db->get('patient');
        return $query->result();
    }

    function getPatientByLimitBySearch($limit, $start, $search, $order, $dir) {
        if (strlen($search)>1)
        {
        $this->db->select('id,name,phone,address,age');
        $this->db->like('id', $search,'after');

        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }

        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('patient');
        return $query->result();
        }
    }

    function getPatientById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('patient');
        return $query->row();
    }

    function getPatientByIonUserId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('patient');
        return $query->row();
    }

    function getPatientByEmail($email) {
        $this->db->where('email', $email);
        $query = $this->db->get('patient');
        return $query->row();
    }

    function updatePatient($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('patient', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('patient');
    }

    function insertMedicalHistory($data) {
        $this->db->insert('medical_history', $data);
    }

    function getMedicalHistoryByPatientId($id) {
        $this->db->where('patient_id', $id);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistory() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medical_history');
        return $query->result();
    }
    
    function getMedicalHistoryWithoutSearch($order, $dir) {
         if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryBySearch($search, $order, $dir) {
         if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search);
        $this->db->or_like('patient_name', $search);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimit($limit, $start, $order, $dir) {
         if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimitBySearch($limit, $start, $search, $order, $dir) {

        $this->db->like('id', $search);

         if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }

        $this->db->or_like('patient_name', $search);
        $this->db->or_like('patient_phone', $search);
        $this->db->or_like('patient_address', $search);

        $this->db->or_like('description', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medical_history');
        return $query->row();
    }

    function updateMedicalHistory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medical_history', $data);
    }

    function insertDiagnosticReport($data) {
        $this->db->insert('diagnostic_report', $data);
    }

    function updateDiagnosticReport($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('diagnostic_report', $data);
    }

    function getDiagnosticReport() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function getDiagnosticReportById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportByInvoiceId($id) {
        $this->db->where('invoice', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportByPatientId($id) {
        $this->db->where('patient', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function insertPatientMaterial($data) {
        $this->db->insert('patient_material', $data);
    }

    function getPatientMaterial() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('patient_material');
        return $query->result();
    }
    
    function getPatientMaterialWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get('patient_material');
        return $query->result();
    }

    function getDocumentBySearch($search, $order, $dir) {
       if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->like('id', $search);
        $this->db->or_like('patient_name', $search);
        $query = $this->db->get('patient_material');
        return $query->result();
    }

    function getDocumentByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($limit, $start);
        $query = $this->db->get('patient_material');
        return $query->result();
    }

    function getDocumentByLimitBySearch($limit, $start, $search, $order, $dir) {

        $this->db->like('id', $search);

        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }

        $this->db->or_like('date_string', $search);

        $this->db->or_like('patient_name', $search);
        $this->db->or_like('patient_phone', $search);
        $this->db->or_like('patient_address', $search);

        $this->db->or_like('title', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('patient_material');
        return $query->result();
    }

    function getPatientMaterialById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('patient_material');
        return $query->row();
    }

    function getPatientMaterialByPatientId($id) {
        $this->db->where('patient', $id);
        $query = $this->db->get('patient_material');
        return $query->result();
    }

    function deletePatientMaterial($id) {
        $this->db->where('id', $id);
        $this->db->delete('patient_material');
    }

    function deleteMedicalHistory($id) {
        $this->db->where('id', $id);
        $this->db->delete('medical_history');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getDueBalanceByPatientId($patient) {
        $query = $this->db->select('gross_total')->where('patient', $patient)->get('payment')->result();
        $deposits = $this->db->select('deposited_amount')->where('patient', $patient)->get('patient_deposit')->result();

        $balance = array();
        $deposit_balance = array();
        foreach ($query as $gross) {
            $balance[] = $gross->gross_total;
        }
        $balance = array_sum($balance);

        foreach ($deposits as $deposit) {
            $deposit_balance[] = $deposit->deposited_amount;
        }
        $deposit_balance = array_sum($deposit_balance);
        $bill_balance = $balance;
        return $due_balance = $bill_balance - $deposit_balance;
    }

    function getPatientInfo($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('id,name,phone');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '%" . $searchTerm . "%' ");
			$this->db->or_where("phone like '%" . $searchTerm . "%' "); //added by shariat
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
        } else {
            $this->db->select('id,name,phone');
            // $this->db->where("name like '%".$searchTerm."%' ");
            //  $this->db->or_where("id like '%".$searchTerm."%' ");
            $this->db->limit(5);
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
        }
        // Initialize Array with fetched data
        $data = array();
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => ucfirst($user['name']) . ', ' . $user['phone'] . ', '. lang('id') . ': ' . $user['id']); //edited by shariat
        }
        return $data;
    }

	//edited by shariat to add phone in datalist
    function getPatientinfoWithAddNewOption($searchTerm) {
            $this->db->order_by('id', 'desc'); //added by shariat
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->select('id,name,phone');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '" . $searchTerm . "%' ");
			$this->db->or_where("phone like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
            }
        } else {
            $this->db->select('id,name,phone');
            $this->db->limit(5);
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
        }
        // Initialize Array with fetched data
        $data = array();
        $data[] = array("id" => 'add_new', "text" => lang('add_new'));
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => ucfirst($user['name']) . ', ' . $user['phone'] . ', '. lang('id') . ': ' . $user['id']);
        }
        return $data;
    }

	//added by shariat to add phone and remove add new in datalist
    function getPatientinfoWithAddNewOptionforLab($searchTerm) {
            $this->db->order_by('id', 'desc'); //added by shariat
        if (!empty($searchTerm)) {
            if (strlen($searchTerm)>1)
            {
            $this->db->select('id,name,phone');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->or_where("id like '" . $searchTerm . "%' ");
			$this->db->or_where("phone like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
            }
        } else {
            $this->db->select('*');
            $this->db->limit(5);
            $fetched_records = $this->db->get('patient');
            $users = $fetched_records->result_array();
        }
        // Initialize Array with fetched data
        $data = array();

        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => ucfirst($user['name']) . ', ' . $user['phone'] . ', '. lang('id') . ': ' . $user['id']);
        }
        return $data;
    }

    function getPatientPharmacyWithoutSearch($order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('patient,patient_name,patient_phone');
        $this->db->group_by('patient');// add group_by
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPatientPharmacyBySearch($search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('patient,patient_name,patient_phone');
        $this->db->group_by('patient');// add group_by
        $this->db->like('patient', $search);
        $this->db->or_like('patient_name', $search);
        $this->db->or_like('patient_phone', $search);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPatientPharmacyByLimit($limit, $start, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('patient,patient_name,patient_phone');
        $this->db->group_by('patient');// add group_by
        $this->db->where('TRIM(patient)>','');
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getPatientPharmacyByLimitBySearch($limit, $start, $search, $order, $dir) {
        if ($order != null) {
            $this->db->order_by($order, $dir);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->select('patient,patient_name,patient_phone');
        $this->db->group_by('patient');// add group_by
        $this->db->like('patient', $search);
        $this->db->or_like('patient_name', $search);
        $this->db->or_like('patient_phone', $search);
        $this->db->limit($limit, $start);
        $query = $this->db->get('pharmacy_payment');
        return $query->result();
    }

    function getDueBalanceForPharmacyByPatientId($patient) {
        $query = $this->db->select('gross_total')->get_where('pharmacy_payment', array('patient' => $patient))->result();
        $deposits = $this->db->select('deposited_amount')->get_where('pharmacy_deposit', array('patient' => $patient))->result();
        $balance = array();
        $deposit_balance = array();
        foreach ($query as $gross) {
            $balance[] = $gross->gross_total;
        }
        $balance = array_sum($balance);

        foreach ($deposits as $deposit) {
            $deposit_balance[] = $deposit->deposited_amount;
        }
        $deposit_balance = array_sum($deposit_balance);
        $bill_balance = $balance;
        return $due_balance = $bill_balance - $deposit_balance;
    }

    function updatePatientPayment($id, $data) {
        $this->db->where('patient', $id);
        $this->db->update('payment', $data);
    }

    function updatePatientPharmacy($id, $data) {
        $this->db->where('patient', $id);
        $this->db->update('pharmacy_payment', $data);
    }

}
